#include <stdio.h>

// #include <mkl.h>
// #include <mkl_scalapack.h>
// #include <mkl_blacs.h>

extern float pslamch_(const int *, const char *);
extern void blacs_pinfo_(int *, int *);
extern void blacs_get_(const int *, const int *, int *);
extern void blacs_gridinit_(int *, const char *, const int *, const int *);
extern void blacs_gridinfo_(const int *, int *, int *, int *, int *);
extern void blacs_gridexit_(const int *);
extern void blacs_exit_(const int *);

int main(void){

int myid, nprocs, ictxt, mycol, myrow, npcol=2, nprow=2;
const int i0=0, i1=1, in1=-1;

blacs_pinfo_(&myid, &nprocs);
blacs_get_(&in1, &i0, &ictxt);
blacs_gridinit_(&ictxt, "C", &nprocs, &i1);

blacs_gridinfo_(&ictxt, &nprow, &npcol, &myrow, &mycol);

float eps = pslamch_(&ictxt, "E");

if (myrow == mycol) printf("OK: Scalapack C: eps= %f\n", eps);

blacs_gridexit_(&ictxt);
blacs_exit_(&i0);

return 0;
}